package examples.entity.intro;

import java.util.List;

/**
 * Business interface of the Bank session bean, a facade for the
 * Account entity bean.
 */

public interface Bank {

    /**
     * List accounts in the bank
     * @return the list of accounts
     */
    List<Account> listAccounts();

    /**
     * Opens a new account
     * @param ownerName
     * @return the account object 
     */
    Account openAccount(String ownerName);

    Account openAccount(String ownerName, int accNum);
    
    void printBigAccounts();
    
    /**
     * Find out the balance of account with given accountNumber
     * @param accountNumber
     * @return the current balance
     */
    int getBalance(int accountNumber);

    /**
     * Increases the balance of account with given accountNumber by amount 
     * @param accountNumber
     * @param amount the amount
     */
    void deposit(int accountNumber, int amount);

    /**
     * Withdraws a given amount, the current balance permitting 
     * @param accountNumber
     * @param amount 
     * @return amount, if successful, 0 otherwise
     */
    int withdraw(int accountNumber, int amount);

    public void checkBalance(int accountNumber);
    
    /**
     * Destroys the entity permanently
     * @param accountNumber
     */
    void close(int accountNumber);
    
    void update(Account a);
}
